"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.UsersService = void 0;
const common_1 = require("@nestjs/common");
const constants_1 = require("../../core/constants");
const role_entity_1 = require("./entity/role.entity");
const user_type_enum_1 = require("../../enum/user.type.enum");
const CorePaginationSQ_1 = require("../../util/CorePaginationSQ");
const sequelize_1 = require("sequelize");
const bcrypt = require("bcrypt");
const user_role_entity_1 = require("./entity/user.role.entity");
let UsersService = class UsersService {
    constructor(userRepository, roleRepository, roleUserRepository) {
        this.userRepository = userRepository;
        this.roleRepository = roleRepository;
        this.roleUserRepository = roleUserRepository;
    }
    async onModuleInit() {
        const CheckRole = await this.roleRepository.count();
        if (CheckRole == 0) {
            await this.roleRepository.bulkCreate([
                {
                    id: 1,
                    name: user_type_enum_1.TypeUser.superAdmin,
                },
                {
                    id: 2,
                    name: user_type_enum_1.TypeUser.admin,
                },
                {
                    id: 3,
                    name: user_type_enum_1.TypeUser.agent,
                },
            ]);
        }
        const CheckUser = await this.userRepository.count();
        if (CheckUser == 0) {
            try {
                await this.userRepository.bulkCreate([
                    {
                        id: 1,
                        email: 'super-admin@gmail.com',
                        first_name: 'Raid',
                        last_name: 'Djhaiche',
                        phone: '+213770171795',
                        password: await bcrypt.hash('123456789', 10),
                        user_role: [
                            {
                                id_role: 1,
                            },
                        ],
                    },
                    {
                        id: 2,
                        first_name: 'Admin',
                        last_name: 'demo',
                        birthday: null,
                        email: 'admin@gmail.com',
                        phone: '+213770171796',
                        gender: 'male',
                        password: await bcrypt.hash('123456789', 10),
                        user_role: [
                            {
                                id_role: 2,
                            },
                        ],
                    },
                    {
                        id: 3,
                        first_name: 'zakaria ',
                        last_name: 'charif ',
                        birthday: null,
                        image: null,
                        email: 'zakariacharif1998@gmail.com',
                        phone: '+213662934692',
                        gender: 'male',
                        password: await bcrypt.hash('123456789', 10),
                        user_role: [
                            {
                                id_role: 2,
                            },
                        ],
                    },
                    {
                        id: 4,
                        first_name: 'ziad',
                        last_name: 'sahnoune',
                        birthday: null,
                        email: 'zizosahnoune@gmail.com',
                        phone: '+213781087771',
                        gender: 'male',
                        password: await bcrypt.hash('123456789', 10),
                        user_role: [
                            {
                                id_role: 2,
                            },
                        ],
                    },
                    {
                        id: 5,
                        first_name: 'KARIM',
                        last_name: 'RAMLI',
                        birthday: null,
                        image: null,
                        email: 'Kariminformatique123@gmail.com',
                        phone: '+213771773819',
                        gender: 'male',
                        password: await bcrypt.hash('123456789', 10),
                        user_role: [
                            {
                                id_role: 2,
                            },
                        ],
                    },
                    {
                        id: 6,
                        first_name: 'dayo ',
                        last_name: 'guettouche',
                        birthday: null,
                        image: null,
                        email: 'dayoguettouche03@gmail.com',
                        phone: '+213672308899',
                        gender: 'male',
                        password: await bcrypt.hash('123456789', 10),
                        user_role: [
                            {
                                id_role: 2,
                            },
                        ],
                    },
                ], {
                    include: [
                        {
                            model: user_role_entity_1.UserRole,
                            as: 'user_role',
                        },
                    ],
                });
            }
            catch (error) {
                console.log(error);
            }
        }
    }
    async find(paginateQuery) {
        return await (0, CorePaginationSQ_1.GetPaginationQuery)({
            entityBuild: this.userRepository,
            dataFilter: paginateQuery,
        });
    }
    async read(id, paginateQuery) {
        return await (0, CorePaginationSQ_1.GetPaginationQuery)({
            entityBuild: this.userRepository,
            dataFilter: paginateQuery,
            isSingle: true,
            id: id,
        });
    }
    async create(data) {
        const user = await this.userRepository.create(data);
        if (user && data.role.length) {
            await this.roleUserRepository.bulkCreate(data.role.map((x) => {
                return {
                    id_role: x.id,
                    id_user: user.id,
                };
            }));
        }
        return user;
    }
    async createClient(data) {
        const Transection = await this.userRepository.sequelize.transaction();
        const user = await this.userRepository.create({
            ...data,
            user_role: [
                {
                    id_role: 3,
                },
            ],
        }, {
            include: [
                {
                    model: user_role_entity_1.UserRole,
                    as: 'user_role',
                },
            ],
        });
        if (user) {
            const dataFinal = await this.userRepository.unscoped().findOne({
                where: {
                    [sequelize_1.Op.or]: {
                        phone: user.phone,
                    },
                },
                include: [role_entity_1.Role],
                transaction: Transection,
            });
            Transection.commit();
            return dataFinal;
        }
    }
    async update(id, data) {
        const user = await this.userRepository.update(data, {
            where: {
                id: id,
            },
            individualHooks: true,
        });
        if (user && data.role && data.role.length) {
            await this.roleUserRepository.destroy({
                force: true,
                where: {
                    id_user: id,
                },
            });
            await this.roleUserRepository.bulkCreate(data.role.map((x) => {
                return {
                    id_role: x.id,
                    id_user: id,
                };
            }));
        }
        return user;
    }
    async remove(id) {
        return await this.userRepository.destroy({
            force: true,
            where: {
                id: id,
            },
        });
    }
    async CheckValid(id) {
        const check = await this.userRepository.count({
            where: {
                id: id,
            },
        });
        if (check) {
            return check;
        }
        else {
            throw new common_1.NotFoundException(`User not found.`);
        }
    }
    async loginAdmin(authData) {
        return await this.userRepository.unscoped().findOne({
            where: {
                [sequelize_1.Op.or]: {
                    email: authData.username,
                    phone: authData.username,
                },
            },
            include: [
                {
                    model: role_entity_1.Role,
                    as: 'role',
                    required: true,
                    where: {
                        id: [1, 2, 3],
                    },
                },
            ],
        });
    }
    async ChangePassword(id) {
        return await this.userRepository.unscoped().findOne({
            where: {
                id: id,
            },
        });
    }
    async role() {
        return await this.roleRepository.findAll();
    }
};
exports.UsersService = UsersService;
exports.UsersService = UsersService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, common_1.Inject)(constants_1.USER_REPOSITORY)),
    __param(1, (0, common_1.Inject)(constants_1.ROLE_REPOSITORY)),
    __param(2, (0, common_1.Inject)(constants_1.ROLE_USER_REPOSITORY)),
    __metadata("design:paramtypes", [Object, Object, Object])
], UsersService);
//# sourceMappingURL=users.service.js.map