import { OnModuleInit } from '@nestjs/common';
import { User } from './entity/user.entity';
import { Pagination } from 'src/util/pagination';
import { Role } from './entity/role.entity';
import { AuthDto } from 'src/auth/dto/auth.dto';
import { UserRole } from './entity/user.role.entity';
import { UserClientDto, UserDto, UserDtoUpdate } from './dto/user.dto';
export declare class UsersService implements OnModuleInit {
    private readonly userRepository;
    private readonly roleRepository;
    private readonly roleUserRepository;
    constructor(userRepository: typeof User, roleRepository: typeof Role, roleUserRepository: typeof UserRole);
    onModuleInit(): Promise<void>;
    find(paginateQuery: Pagination): Promise<User | import("src/util/CorePaginationSQ").PaginationQueryReturn<User>>;
    read(id: number, paginateQuery: Pagination): Promise<User | import("src/util/CorePaginationSQ").PaginationQueryReturn<User>>;
    create(data: UserDto): Promise<User>;
    createClient(data: UserClientDto): Promise<User>;
    update(id: number, data: UserDtoUpdate): Promise<[affectedCount: number]>;
    remove(id: number): Promise<number>;
    CheckValid(id: number): Promise<number>;
    loginAdmin(authData: AuthDto): Promise<User>;
    ChangePassword(id: number): Promise<User>;
    role(): Promise<Role[]>;
}
