import { UsersService } from './users.service';
import { Pagination } from 'src/util/pagination';
import { UserDto, UserDtoUpdate } from './dto/user.dto';
import { UserProps } from 'src/types/jwtType';
export declare class UsersController {
    private readonly usersService;
    constructor(usersService: UsersService);
    find(paginateQuery: Pagination, user: UserProps): Promise<import("./entity/user.entity").User | import("../../util/CorePaginationSQ").PaginationQueryReturn<import("./entity/user.entity").User>>;
    read(id: number, paginateQuery: Pagination, dataUser: UserProps): Promise<import("./entity/user.entity").User | import("../../util/CorePaginationSQ").PaginationQueryReturn<import("./entity/user.entity").User>>;
    creat(data: UserDto): Promise<import("./entity/user.entity").User>;
    update(id: number, data: UserDtoUpdate): Promise<[affectedCount: number]>;
    remove(id: number): Promise<number>;
}
