import { OnModuleInit } from '@nestjs/common';
import { Pagination } from 'src/util/pagination';
import { Shop } from './entity/shop.entity';
import { ShopDto, ShopDtoUpdate } from './dto/shop.dto';
import { UserProps } from 'src/types/jwtType';
import { ShopUser } from './entity/shop.user.entity';
export declare class ShopService implements OnModuleInit {
    private readonly shopRepository;
    private readonly shopUserRepository;
    constructor(shopRepository: typeof Shop, shopUserRepository: typeof ShopUser);
    onModuleInit(): Promise<void>;
    find(paginateQuery: Pagination): Promise<Shop | import("src/util/CorePaginationSQ").PaginationQueryReturn<Shop>>;
    read(id: number, paginateQuery: Pagination): Promise<Shop | import("src/util/CorePaginationSQ").PaginationQueryReturn<Shop>>;
    create(data: ShopDto): Promise<Shop>;
    update(dataUser: UserProps, id: number, data: ShopDtoUpdate): Promise<[affectedCount: number]>;
    remove(id: number): Promise<number>;
    addUserToShop(id_shop: number, id: number): Promise<ShopUser>;
    removeUserShop(id_shop: number, id: number): Promise<number>;
}
