"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ShopsController = void 0;
const common_1 = require("@nestjs/common");
const get_pagination_decorator_1 = require("../../util/get-pagination.decorator");
const roles_decorator_1 = require("../../auth/decorators/roles.decorator");
const shop_service_1 = require("./shop.service");
const shop_dto_1 = require("./dto/shop.dto");
const user_decorator_1 = require("../../auth/decorators/user.decorator");
const user_type_enum_1 = require("../../enum/user.type.enum");
let ShopsController = class ShopsController {
    constructor(shopsService) {
        this.shopsService = shopsService;
    }
    find(paginateQuery, data) {
        if (data.role.includes(user_type_enum_1.TypeUser.admin) ||
            data.role.includes(user_type_enum_1.TypeUser.agent)) {
            paginateQuery.relations.push('user');
            paginateQuery.filter.push({
                field: 'user.id',
                operation: '=',
                value: data.id.toString(),
            });
        }
        return this.shopsService.find(paginateQuery);
    }
    read(id, paginateQuery, data) {
        if (data.role.includes(user_type_enum_1.TypeUser.superAdmin)) {
            paginateQuery.relations.push('user');
        }
        return this.shopsService.read(id, paginateQuery);
    }
    creat(data) {
        return this.shopsService.create(data);
    }
    update(id, data, dataUser) {
        return this.shopsService.update(dataUser, id, data);
    }
    remove(id) {
        return this.shopsService.remove(id);
    }
};
exports.ShopsController = ShopsController;
__decorate([
    (0, roles_decorator_1.Roles)('superAdmin', 'admin', 'agent'),
    (0, common_1.HttpCode)(200),
    (0, common_1.Get)(),
    __param(0, (0, get_pagination_decorator_1.GetPagination)()),
    __param(1, (0, user_decorator_1.User)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object]),
    __metadata("design:returntype", void 0)
], ShopsController.prototype, "find", null);
__decorate([
    (0, common_1.HttpCode)(200),
    (0, common_1.Get)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, get_pagination_decorator_1.GetPagination)()),
    __param(2, (0, user_decorator_1.User)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Object, Object]),
    __metadata("design:returntype", void 0)
], ShopsController.prototype, "read", null);
__decorate([
    (0, roles_decorator_1.Roles)('superAdmin'),
    (0, common_1.HttpCode)(201),
    (0, common_1.Post)(),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [shop_dto_1.ShopDto]),
    __metadata("design:returntype", void 0)
], ShopsController.prototype, "creat", null);
__decorate([
    (0, roles_decorator_1.Roles)('superAdmin', 'admin'),
    (0, common_1.HttpCode)(204),
    (0, common_1.Patch)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Body)()),
    __param(2, (0, user_decorator_1.User)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, shop_dto_1.ShopDtoUpdate, Object]),
    __metadata("design:returntype", void 0)
], ShopsController.prototype, "update", null);
__decorate([
    (0, roles_decorator_1.Roles)('superAdmin'),
    (0, common_1.HttpCode)(204),
    (0, common_1.Delete)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number]),
    __metadata("design:returntype", void 0)
], ShopsController.prototype, "remove", null);
exports.ShopsController = ShopsController = __decorate([
    (0, common_1.Controller)('shop'),
    __metadata("design:paramtypes", [shop_service_1.ShopService])
], ShopsController);
//# sourceMappingURL=shop.controller.js.map