import { Pagination } from 'src/util/pagination';
import { ShopService } from './shop.service';
import { ShopDto, ShopDtoUpdate } from './dto/shop.dto';
import { UserProps } from 'src/types/jwtType';
export declare class ShopsController {
    private readonly shopsService;
    constructor(shopsService: ShopService);
    find(paginateQuery: Pagination, data: UserProps): Promise<import("./entity/shop.entity").Shop | import("../../util/CorePaginationSQ").PaginationQueryReturn<import("./entity/shop.entity").Shop>>;
    read(id: number, paginateQuery: Pagination, data: UserProps): Promise<import("./entity/shop.entity").Shop | import("../../util/CorePaginationSQ").PaginationQueryReturn<import("./entity/shop.entity").Shop>>;
    creat(data: ShopDto): Promise<import("./entity/shop.entity").Shop>;
    update(id: number, data: ShopDtoUpdate, dataUser: UserProps): Promise<[affectedCount: number]>;
    remove(id: number): Promise<number>;
}
