"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AuthService = void 0;
const common_1 = require("@nestjs/common");
const bcrypt = require("bcrypt");
const jwt_1 = require("@nestjs/jwt");
const config_1 = require("@nestjs/config");
const users_service_1 = require("../modules/users/users.service");
let AuthService = class AuthService {
    constructor(userService, jwtService, configService) {
        this.userService = userService;
        this.jwtService = jwtService;
        this.configService = configService;
    }
    async authenticateAdmin(authenticateDto) {
        const user = await this.userService.loginAdmin(authenticateDto);
        if (!user)
            throw new common_1.NotFoundException('Invalid credentials');
        const passwordValid = await bcrypt.compare(authenticateDto.password, user.password);
        if (!passwordValid) {
            throw new common_1.NotFoundException('Invalid credentials');
        }
        return await this.jwtServiceSing(user);
    }
    async CreateClient(dataUser) {
        const user = await this.userService.createClient(dataUser);
        const passwordValid = await bcrypt.compare(dataUser.password, user.password);
        if (!passwordValid) {
            throw new common_1.NotFoundException('Invalid credentials');
        }
        return await this.jwtServiceSing(user);
    }
    async jwtServiceSing(data) {
        const token = await this.jwtService.sign({
            id: data.id,
            first_name: data.first_name,
            last_name: data.last_name,
            email: data.email,
            phone: data.phone,
            role: data.role.map((role) => {
                return role.name;
            }),
        }, {
            secret: this.configService.get('JWTKEY'),
            expiresIn: this.configService.get('TOKEN_EXPIRATION'),
        });
        return { token };
    }
    async getProfile(id) {
        const user = await this.userService.read(id, {
            limit: 1,
            page: 0,
            relations: ['role', 'shop'],
        });
        return user;
    }
    async updateProfile(id, data) {
        return await this.userService.update(id, data);
    }
    async ChangePassword(id, data) {
        const oldeUser = await this.userService.ChangePassword(id);
        const passwordValid = await bcrypt.compare(data.old_password, oldeUser.password);
        if (passwordValid) {
            await this.userService.update(id, {
                password: data.new_password,
            });
        }
        else {
            throw new common_1.NotFoundException('Invalid credentials');
        }
    }
};
exports.AuthService = AuthService;
exports.AuthService = AuthService = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [users_service_1.UsersService,
        jwt_1.JwtService,
        config_1.ConfigService])
], AuthService);
//# sourceMappingURL=auth.service.js.map